
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Sep 11 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version MNG_ATP_TST_Data.c#1:csrc:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "MNG_ATP_TST.h"

/************************ Defines *******************************/

/* canceling the lint warning:
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */

/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/

/* Buffers for Random vector test */
DxUint8_t TST_MNG_RndBuf[MNG_TST_MAX_BUF_SIZE_IN_BYTES];
DxUint8_t TST_MNG_RndBuf2[MNG_TST_MAX_BUF_SIZE_IN_BYTES];

/* Data struct for RKEK test */
TST_MNG_RKEK_TestDataStruct TST_MNG_RKEK_TestData[] = 
{
  #if TST_RKEK_SIZE_16_BYTE
  {
    /*TST_Name*/
    {"Acceptance test - RKEK AES key 256 bits"},
    /* TST_KeyLen*/
    16,
    /*TST_Key*/
    {0x9a,0x51,0x37,0x93,0xc5,0x0e,0x87,0x53,0xb9,0xd5,0x88,0x8c,0x9c,0xc3,0x36,0x5a},
    /*TST_DataLen*/
    16,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_Output*/
    {0},
    /*TST_ExpectedOutput*/
    {0xB7,0x05,0xE2,0xD8,0x12,0x9A,0xBF,0x2D,0x99,0x35,0x1D,0x85,0x06,0x64,0xE8,0xF0},
    /*TST_Mode*/
    CRYS_AES_CBC_mode,
    /*TST_IvCounter*/
    {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
    /*TST_KeySize*/
    CRYS_AES_Key128BitSize
  },
  #else
  {
    /*TST_Name*/
    {"Acceptance test - RKEK AES key 256 bits"},
    /* TST_KeyLen*/
    32,
    /*TST_Key*/
    {0x9a,0x51,0x37,0x93,0xc5,0x0e,0x87,0x53,0xb9,0xd5,0x88,0x8c,0x9c,0xc3,0x36,0x5a,
     0xe9,0xfa,0x7a,0x12,0x70,0x96,0x4f,0xd5,0x9f,0xe3,0x25,0x65,0xff,0xcd,0x82,0x38},
    /*TST_DataLen*/
    16,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_Output*/
    {0},
    /*TST_ExpectedOutput*/
    {0xce,0xd4,0x63,0x27,0x0a,0x48,0x1e,0xda,0x45,0x0e,0xd7,0xd5,0xb7,0xac,0x23,0x8d},
    /*TST_Mode*/
    CRYS_AES_CBC_mode,
    /*TST_IvCounter*/
    {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
    /*TST_KeySize*/
    CRYS_AES_Key256BitSize    
  }  
  #endif    
};

TST_MNG_PUBKey_TestDataStruct TST_MNG_OEMStaticPUBKey_TestData[] = 
{   
  {
    /*TST_Name*/
    {"Acceptance test - RKEK, OEM pub key size 256Bytes"},
    /*TST_N*/
    {0xbe,0x17,0xe2,0x0e,0x7f,0xd2,0xa2,0xa2,0x9d,0x9e,0xd4,0x66,0xf5,0x13,0x2c,0xd6,
     0x7f,0x92,0x47,0x58,0x9a,0x74,0x78,0x48,0x3b,0x6e,0x94,0x6e,0xcc,0x06,0x6c,0xa3,
     0x76,0xb7,0x88,0xf0,0x73,0x9a,0x52,0x1d,0x4e,0x01,0x95,0x6a,0x29,0x5f,0x0e,0x17,
     0x9d,0x31,0x9e,0x73,0x80,0xcb,0x40,0xc5,0xcd,0xb8,0x95,0xce,0xf1,0x56,0x8d,0xbb,
     0x5e,0xb0,0xee,0x14,0x37,0x34,0x43,0xd8,0x3d,0x88,0x93,0xc6,0x63,0x8a,0xb8,0x71,
     0x9b,0xa4,0x3d,0x11,0xf0,0xe3,0xcc,0x2e,0x2c,0x21,0xf3,0x1f,0x39,0x94,0x80,0x12,
     0xbd,0xbb,0xbc,0x46,0xf5,0x9b,0xf9,0x09,0xea,0xa4,0x8a,0xf0,0xea,0x9c,0x52,0x55,
     0xb0,0x9f,0x0d,0xde,0xfb,0x6f,0x2b,0xbb,0x64,0x34,0x70,0x29,0x87,0x5a,0x72,0x03,
     0xe4,0x8c,0x9c,0xf9,0xbc,0x5c,0x8f,0x59,0xd3,0x9b,0x70,0x04,0x75,0x19,0xe0,0x35,
     0x0c,0x77,0x0d,0xbd,0x4d,0x9a,0x0a,0xcd,0xae,0xba,0xa0,0x18,0x40,0xf1,0xa5,0xfa,
     0x89,0xb7,0xa0,0xab,0x9b,0x52,0xbb,0x60,0x24,0x3f,0xb0,0x7c,0x8e,0x7c,0x24,0x74,
     0x08,0x57,0x7d,0x44,0x60,0x86,0x55,0xa0,0xff,0x39,0x77,0xe2,0x49,0xd2,0x2a,0xa0,
     0xbc,0x2a,0xe9,0x3b,0x2d,0xde,0x8b,0xf0,0x3e,0xe0,0x05,0x13,0x9a,0x57,0xdc,0x3c,
     0xc9,0xc0,0xf6,0x45,0x5c,0xfa,0x59,0xa8,0x53,0xee,0xda,0xc6,0x35,0x07,0x1e,0xe7,
     0xd7,0x12,0x9e,0x8f,0x10,0x45,0xc1,0x21,0x6e,0xed,0x8a,0xec,0x3a,0x9a,0x32,0xa7,
     0x57,0x6e,0x47,0x0b,0x5d,0x4b,0xe3,0x34,0x8e,0xc6,0xe2,0xfd,0x09,0x06,0x18,0x3f},
    /*TST_NLen*/
    256,
    /*TST_E*/
    0x00010001,
    /*TST_Data*/
    {0},
    /*TST_Output*/
    {0},
    /*TST_ExpectedOutput*/
    {0}
  }
};

/* Data struct for MTC test */
TST_MNG_MTC_TestDataStruct TST_MNG_MTC_TestData[] =
{
  {
    /*TST_Name*/
    {"Acceptance test - Monotonic counter test"},
    /*TST_KeyLen*/
    32,
    /*TST_Key*/
    {0},
    /*TST_WrappedMTCLen*/
    0,
    /*TST_WrappedMTC*/
    {0},
    /*TST_MTCLen*/
    4,
    /*TST_MTC*/
    {0}
  }
};

/* Data struct for the OEM pub key tests */
TST_MNG_PUBKey_TestDataStruct TST_MNG_OEMPUBKey_TestData[] = 
{   
  {
    /*TST_Name*/
    {"Acceptance test - OEM pub key size 256Bytes"},
    /*TST_N*/
    {0xb8,0xe0,0xa5,0x8c,0x74,0xd7,0xcd,0xeb,0xb2,0xa3,0x40,0x34,0x58,0xca,0x21,0xa4,
     0xb4,0xfd,0xaf,0x9c,0xd7,0x5c,0xd4,0xa9,0x88,0x90,0x81,0x61,0x12,0x09,0x48,0xb0,
     0x59,0x25,0x2a,0xb2,0xfb,0x1a,0x74,0xe9,0x18,0x0e,0xe7,0x42,0x9a,0xac,0x9f,0x30,
     0x28,0x33,0x19,0x2e,0x00,0x1b,0x04,0xa1,0x38,0xf7,0x65,0x10,0xdb,0xce,0x45,0xa9,
     0x62,0x87,0xd6,0xb4,0xb1,0x96,0x98,0x91,0x12,0x8c,0x56,0xc7,0xd4,0x89,0x25,0xe0,
     0xdb,0x3f,0x63,0xeb,0x88,0x0a,0xad,0xaf,0x34,0x5e,0x77,0x0d,0xdf,0x96,0xd3,0x5a,
     0xb6,0xf5,0x13,0x8b,0xd2,0x25,0xa7,0x46,0xeb,0x2a,0x7f,0xba,0x2f,0xd1,0x6a,0x4c,
     0x99,0xd8,0x7a,0xde,0x17,0xb2,0x9d,0x99,0x95,0x5a,0x27,0xe3,0xa8,0x3c,0xbf,0xd8,
     0xbc,0xb6,0x70,0xe3,0x86,0x59,0x75,0x8d,0x95,0x12,0x1a,0x5c,0xf0,0x53,0xa8,0x38,
     0x0c,0xa6,0x5d,0xcf,0x5d,0x51,0xcd,0xb0,0x66,0xe1,0xa6,0xbc,0x31,0x36,0x2e,0xfd,
     0x4f,0xaa,0xe3,0x3e,0x47,0xfa,0xb8,0x0a,0x08,0xf8,0x8f,0xe2,0xf1,0xd6,0x43,0x47,
     0x98,0x11,0x26,0x87,0x9e,0xea,0xe7,0xa4,0x77,0x28,0xef,0x59,0xda,0x19,0x4d,0xcb,
     0xc3,0x64,0x11,0xe7,0xc8,0x48,0x3a,0x25,0x2b,0xa4,0xea,0xb1,0xbe,0x96,0xd4,0x24,
     0x12,0x75,0xd1,0xec,0x85,0xc6,0xb1,0x7f,0x19,0x00,0xfa,0xa5,0x59,0x83,0xc5,0x79,
     0x4e,0x35,0x2d,0xf2,0xd2,0xe5,0x18,0xf5,0xe9,0x08,0x93,0xad,0x72,0x58,0x3e,0x4f,
     0xbe,0x3a,0xc9,0x0d,0x6b,0xd6,0xcf,0x71,0x92,0x16,0x06,0xdc,0xeb,0xcb,0xcd,0x3d},
    /*TST_NLen*/
    256,
    /*TST_E*/
    0x03,
    /*TST_Data*/
    {0xa9,0xdd,0x98,0xd5,0x84,0x32,0x27,0xbc,0x51,0x82,0x52,0x29,0x84,0xc1,0x4d,0x4c,
     0x17,0x50,0x07,0x2f,0x80,0x21,0xb7,0xf7,0xe0,0x1b,0xb7,0x67,0x7d,0xc0,0x96,0xa5,
     0x72,0x0d,0x69,0x41,0xa5,0xa1,0x61,0x73,0xfa,0x22,0xa3,0xa4,0xc6,0xdd,0x53,0x30,
     0x87,0xac,0xf2,0x6b,0xd2,0x1d,0xeb,0xe2,0x8c,0xd0,0x68,0xe3,0x5d,0x21,0x6a,0x3f,
     0x62,0x07,0x19,0x4e,0x22,0x3c,0x59,0x34,0xc4,0x9f,0x9d,0x63,0x7f,0xd6,0x00,0x61,
     0x51,0x37,0x92,0xcc,0xf4,0xe9,0xef,0x9b,0x0e,0x46,0x17,0xa6,0xa8,0x84,0x79,0x69,
     0xe1,0x95,0x51,0x04,0xe3,0x4b,0x34,0x87,0x17,0xc0,0xe9,0x6d,0x95,0xf5,0x7b,0x66,
     0xdf,0xb9,0x8c,0x5a,0xce,0xcd,0xec,0xaa,0xcc,0x45,0x6b,0xb9,0x44,0x31,0xeb,0xab,
     0x57,0x7d,0xb9,0x6c,0xd1,0x16,0x1d,0xf4,0x5b,0x4e,0x2f,0xca,0xf2,0x82,0xed,0xc7,
     0x97,0xfa,0x8b,0x1d,0x48,0x10,0x0a,0x98,0x30,0x95,0x0c,0x23,0x1b,0x70,0xe7,0x8d,
     0x2c,0x88,0xf8,0x8d,0xd2,0xe5,0x3a,0x04,0xf8,0x12,0x16,0x83,0x7c,0xc5,0x7d,0x0d,
     0xe3,0xc1,0x35,0x1e,0x4b,0xfc,0x70,0xeb,0xa0,0xfd,0xa3,0xec,0x13,0x89,0x95,0x98,
     0xc8,0x7e,0xb7,0x70,0xcf,0xff,0xb3,0x3e,0x56,0xd1,0x47,0x9f,0x1d,0x05,0x54,0xbf,
     0x2a,0xd8,0x32,0x64,0xbd,0xd7,0x47,0x2e,0x86,0x47,0xd8,0x1d,0x16,0xc3,0x1e,0x53,
     0x94,0x27,0x9d,0x1b,0xb1,0xad,0xb1,0x2b,0xdd,0x56,0x6a,0x26,0xbc,0x8c,0x99,0x65,
     0xd3,0x05,0x2b,0xf7,0x88,0xea,0xb6,0xe6,0x49,0x39,0x52,0xbc,0x0b,0x68,0xaa,0x46},
    /*TST_Output*/
    {0},
    /*TST_ExpectedOutput*/
    {0x2d,0x27,0xbb,0xf8,0xb4,0xdf,0xed,0x2d,0x34,0x43,0x51,0x0e,0xf9,0x76,0x34,0xd6,
     0xb9,0x78,0x92,0x82,0xd9,0xa7,0x03,0x3f,0x95,0x68,0x20,0x3e,0xe1,0x1e,0x66,0x0d,
     0x54,0x39,0xe7,0x05,0xe5,0xe3,0xd5,0x22,0x96,0x8a,0x44,0xbd,0x8c,0x80,0x4a,0xed,
     0xdf,0xb0,0xd4,0x07,0x72,0xae,0x4d,0xb0,0x36,0x51,0xee,0x89,0x43,0x0b,0x41,0xb6,
     0xb3,0xd1,0x01,0x23,0x79,0x09,0x0e,0x14,0x73,0x1b,0x3e,0x49,0xfd,0xf7,0x2f,0x90,
     0xda,0xe1,0xc2,0x61,0x0c,0x65,0x32,0xb8,0x07,0x09,0x46,0x81,0x16,0x49,0x54,0x1c,
     0xc5,0x28,0x0e,0xdc,0x9d,0xfb,0x91,0xc8,0xd8,0xff,0xe3,0x8a,0xae,0x21,0x07,0xdb,
     0x36,0x44,0xfe,0x0c,0xcf,0xb7,0xa7,0x96,0x5d,0x01,0x02,0xe2,0x0d,0x09,0xad,0x4b,
     0x63,0x15,0x6e,0x53,0x2d,0x02,0xb5,0xe6,0x2c,0x54,0x39,0xaf,0x51,0x88,0xd1,0x11,
     0xe5,0x47,0xc3,0xfe,0xd5,0x25,0x79,0x9a,0xbe,0x9b,0xd8,0xf9,0x77,0xbe,0xf9,0xeb,
     0x22,0x54,0xac,0x0c,0xef,0x97,0xad,0xb2,0xc0,0xa3,0x1c,0x35,0xa5,0xf4,0xf7,0x80,
     0x12,0x0f,0x4e,0x1d,0x30,0xa3,0xaa,0x45,0xe7,0x3e,0xf7,0xd9,0x84,0x5d,0xf7,0xbe,
     0x27,0xf8,0x81,0xb8,0x8e,0x5f,0x8c,0x7f,0x5f,0x73,0xf2,0x4e,0x3e,0xb2,0x9b,0xf5,
     0x27,0x74,0x1b,0x90,0x4f,0xc7,0xa0,0x23,0xc2,0x91,0xec,0xa3,0x15,0x17,0x0f,0x50,
     0x25,0x85,0xf0,0x47,0x4b,0x81,0x1b,0x9f,0x67,0xeb,0x12,0x39,0xa7,0xf9,0x74,0xd5,
     0x26,0x06,0x36,0xdf,0x04,0xef,0xd3,0x01,0xdd,0x81,0x88,0xe4,0x29,0xf8,0x22,0x46}
  }
};

/* Data struct for the SJTAG pub key tests */
TST_MNG_PUBKey_TestDataStruct TST_MNG_SJTAGPUBKey_TestData[] = 
{
  {
    /*TST_Name*/
    {"Acceptance test - OEM pub key size 256Bytes"},
    /*TST_N*/
    {0xd1,0xfd,0x8a,0x84,0x3b,0x31,0x8e,0x8d,0x5e,0x4b,0xdf,0x5a,0x13,0x91,0x38,0x30,
     0xa0,0x84,0xbb,0xf4,0x35,0xcf,0xc1,0x13,0x93,0x36,0x58,0x08,0x5b,0xdc,0x56,0xff,
     0x15,0x62,0x5f,0x76,0x08,0xd5,0x4a,0x0c,0xb4,0xce,0xee,0x34,0x5a,0x3a,0x30,0x47,
     0x04,0xa3,0xa5,0x44,0x27,0xf5,0xdf,0x1b,0x45,0x02,0x41,0xb6,0xec,0x1d,0x9e,0xa2,
     0xd4,0x77,0xaa,0x7e,0x54,0x59,0x7a,0x1d,0x31,0x77,0x0e,0xf6,0xa3,0x76,0x15,0xa4,
     0xd8,0x8f,0xe7,0xa1,0x7f,0xd0,0xe5,0xa0,0x70,0x05,0x54,0xd9,0x40,0x61,0xac,0xe9,
     0x27,0x7d,0xaf,0xc0,0x4a,0x93,0xb0,0x04,0x5b,0x86,0xf9,0x6b,0x22,0xa5,0x4c,0x18,
     0x4d,0x3c,0x1c,0x9e,0x60,0xc0,0xf9,0xac,0x65,0x36,0x16,0xba,0x2f,0x44,0x92,0x8a,
     0xca,0x56,0xbd,0x2f,0x1a,0x2b,0x4e,0xc8,0xb1,0x4d,0x6f,0x24,0x3b,0x70,0xe0,0xb9,
     0x42,0xad,0xf1,0x26,0x6a,0x6d,0x3e,0x23,0x27,0xee,0x68,0xde,0xa3,0x09,0x6b,0xa3,
     0x48,0xd7,0x80,0xc8,0x6b,0xf1,0x91,0xe5,0xcc,0xb3,0x37,0xc2,0xb8,0xf5,0x44,0x24,
     0x04,0xe2,0x34,0x82,0x4c,0x11,0x76,0x54,0xbc,0x21,0xa3,0x1b,0x0a,0x99,0x79,0x25,
     0x9a,0xb1,0x85,0xcc,0x72,0x40,0xf4,0x42,0xd7,0x40,0x49,0x47,0x6a,0x96,0x2a,0xff,
     0xa0,0x50,0x56,0xd9,0xc6,0x33,0x48,0x4d,0xa5,0x38,0x92,0x69,0x4f,0xa1,0xbd,0x2f,
     0x31,0xae,0xe2,0x27,0xb6,0x31,0x1d,0xc0,0x36,0xcf,0x43,0x4e,0x4b,0x7a,0xa5,0xad,
     0xee,0x37,0x96,0xf8,0xd0,0x7d,0x34,0x47,0x5c,0x65,0x8c,0x2f,0xe0,0xe0,0xed,0x37},
    /*TST_NLen*/
    256,
    /*TST_E*/
    0x03,
    /*TST_Data*/
    {0xa9,0xdd,0x98,0xd5,0x84,0x32,0x27,0xbc,0x51,0x82,0x52,0x29,0x84,0xc1,0x4d,0x4c,
     0x17,0x50,0x07,0x2f,0x80,0x21,0xb7,0xf7,0xe0,0x1b,0xb7,0x67,0x7d,0xc0,0x96,0xa5,
     0x72,0x0d,0x69,0x41,0xa5,0xa1,0x61,0x73,0xfa,0x22,0xa3,0xa4,0xc6,0xdd,0x53,0x30,
     0x87,0xac,0xf2,0x6b,0xd2,0x1d,0xeb,0xe2,0x8c,0xd0,0x68,0xe3,0x5d,0x21,0x6a,0x3f,
     0x62,0x07,0x19,0x4e,0x22,0x3c,0x59,0x34,0xc4,0x9f,0x9d,0x63,0x7f,0xd6,0x00,0x61,
     0x51,0x37,0x92,0xcc,0xf4,0xe9,0xef,0x9b,0x0e,0x46,0x17,0xa6,0xa8,0x84,0x79,0x69,
     0xe1,0x95,0x51,0x04,0xe3,0x4b,0x34,0x87,0x17,0xc0,0xe9,0x6d,0x95,0xf5,0x7b,0x66,
     0xdf,0xb9,0x8c,0x5a,0xce,0xcd,0xec,0xaa,0xcc,0x45,0x6b,0xb9,0x44,0x31,0xeb,0xab,
     0x57,0x7d,0xb9,0x6c,0xd1,0x16,0x1d,0xf4,0x5b,0x4e,0x2f,0xca,0xf2,0x82,0xed,0xc7,
     0x97,0xfa,0x8b,0x1d,0x48,0x10,0x0a,0x98,0x30,0x95,0x0c,0x23,0x1b,0x70,0xe7,0x8d,
     0x2c,0x88,0xf8,0x8d,0xd2,0xe5,0x3a,0x04,0xf8,0x12,0x16,0x83,0x7c,0xc5,0x7d,0x0d,
     0xe3,0xc1,0x35,0x1e,0x4b,0xfc,0x70,0xeb,0xa0,0xfd,0xa3,0xec,0x13,0x89,0x95,0x98,
     0xc8,0x7e,0xb7,0x70,0xcf,0xff,0xb3,0x3e,0x56,0xd1,0x47,0x9f,0x1d,0x05,0x54,0xbf,
     0x2a,0xd8,0x32,0x64,0xbd,0xd7,0x47,0x2e,0x86,0x47,0xd8,0x1d,0x16,0xc3,0x1e,0x53,
     0x94,0x27,0x9d,0x1b,0xb1,0xad,0xb1,0x2b,0xdd,0x56,0x6a,0x26,0xbc,0x8c,0x99,0x65,
     0xd3,0x05,0x2b,0xf7,0x88,0xea,0xb6,0xe6,0x49,0x39,0x52,0xbc,0x0b,0x68,0xaa,0x46},
    /*TST_Output*/
    {0},
    /*TST_ExpectedOutput*/
    {0x82,0xc3,0x2d,0xba,0x8b,0xd6,0x22,0xf0,0xa9,0x7c,0xeb,0x33,0xd4,0x76,0x9a,0xe3,
     0x0c,0xf3,0x19,0xe8,0xdf,0x6a,0x00,0xaa,0xa1,0xd3,0xa2,0xdd,0xf5,0x8d,0x16,0x32,
     0x38,0x8e,0xfb,0xba,0x9d,0x15,0x8e,0x64,0xfc,0x4d,0x8d,0x11,0xaa,0x33,0xbc,0x76,
     0xa4,0x24,0x8e,0x68,0xbb,0x10,0x36,0xe3,0xad,0x30,0x9b,0x41,0xe3,0x71,0x72,0x11,
     0x6f,0xc3,0xf6,0x3a,0xb1,0xf7,0x8f,0x19,0x22,0x64,0x77,0x65,0x9f,0x9f,0x42,0xa6,
     0x9d,0xc0,0x8c,0xd0,0x75,0xcf,0x57,0x82,0x28,0x02,0x70,0x62,0x96,0x57,0x2e,0x54,
     0x85,0xea,0xb7,0x8d,0x10,0x15,0xa2,0x37,0xf4,0xb9,0x51,0x81,0x37,0x3d,0x6d,0x07,
     0xe0,0xf1,0x6f,0xf5,0x88,0xa4,0x16,0x3f,0xd4,0xf9,0xde,0xa7,0xeb,0xf9,0x39,0xce,
     0x9d,0xda,0x89,0x93,0x65,0x05,0xec,0x9d,0x3e,0x4e,0x3a,0x56,0x44,0x65,0xfd,0xfe,
     0x2a,0xce,0x1e,0x4b,0xca,0x58,0xe5,0x72,0xa1,0x69,0x58,0xe2,0xbe,0x54,0x22,0x2e,
     0x91,0x56,0x58,0x9c,0xb9,0x79,0x83,0x58,0x47,0x43,0x47,0x2e,0x4e,0x12,0xed,0x46,
     0x54,0xdd,0x99,0x58,0xbf,0x42,0x5a,0x81,0x95,0x05,0x86,0x39,0x3f,0x3b,0xf3,0x9b,
     0x66,0x7b,0xa5,0xf0,0x08,0x00,0x86,0x2f,0xc7,0x52,0xf1,0x58,0xdc,0x10,0x3e,0x86,
     0xe4,0x9c,0x96,0xf2,0x9a,0x86,0x99,0x1c,0x25,0xff,0x7c,0x41,0x0f,0xbb,0x39,0x6c,
     0xb2,0x8e,0x2c,0x8a,0xd8,0x1f,0x82,0x76,0xc4,0xf5,0x40,0x13,0x26,0xf0,0x49,0x73,
     0xf3,0xdb,0xb1,0x28,0x14,0x7c,0x0e,0xe9,0xfd,0x19,0x26,0x67,0x06,0x2b,0x8f,0x5b}
  }
};

const int TST_NumberOf_RKEKAcceptanceTests = sizeof(TST_MNG_RKEK_TestData)/sizeof(TST_MNG_RKEK_TestData[0]);
const int TST_NumberOf_MTCAcceptanceTests = sizeof(TST_MNG_MTC_TestData)/sizeof(TST_MNG_MTC_TestData[0]);
const int TST_NumberOf_OEMAcceptanceTests = sizeof(TST_MNG_OEMPUBKey_TestData)/sizeof(TST_MNG_OEMPUBKey_TestData[0]);
const int TST_NumberOf_SJTAGAcceptanceTests = sizeof(TST_MNG_SJTAGPUBKey_TestData)/sizeof(TST_MNG_SJTAGPUBKey_TestData[0]);
